/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.simulation;

import CH.ifa.draw.framework.Painter;
import CH.ifa.draw.standard.BufferedUpdateStrategy;
import DE.siemens.ad.logo.app.comp.HideableToolBar;
import DE.siemens.ad.logo.app.comp.MinimizableToolbar;
import DE.siemens.ad.logo.app.comp.ToolBarLayout;
import DE.siemens.ad.logo.dialog.MessageWindow;
import DE.siemens.ad.logo.dialog.PIControllerWindow;
import DE.siemens.ad.logo.dialog.SimulationOptionsPanel;
import DE.siemens.ad.logo.dialog.comp.DataTableWindow;
import DE.siemens.ad.logo.model.AbstractInputSimulationParameter;
import DE.siemens.ad.logo.model.AnalogInputSimulationParameter;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockNameChangedListener;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.InterpreterListener;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.ParameterSetListener;
import DE.siemens.ad.logo.model.SimulationParameter;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.InputBlock;
import DE.siemens.ad.logo.model.block.OutputBlock;
import DE.siemens.ad.logo.util.BlockByNameComparator;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoProperties;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.simulation.EnableMsgOnlineAction;
import DE.siemens.ad.pdraw.simulation.InputSimulationBar;
import DE.siemens.ad.pdraw.simulation.OnlineTestInterpreter;
import DE.siemens.ad.pdraw.simulation.OnlineTestTool;
import DE.siemens.ad.pdraw.simulation.RunningTool;
import DE.siemens.ad.pdraw.simulation.WatchDataTableAction;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import DE.siemens.ad.pdraw.standard.SimulationUpdateStrategy;
import DE.siemens.ad.pdraw.util.AnalogOutputDisplay;
import DE.siemens.ad.pdraw.util.BinaryOutputDisplay;
import DE.siemens.ad.pdraw.util.OutputDisplay;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.JToolBar;

public class SimulationManager
implements ParameterSetListener,
BlockNameChangedListener {
    private SimulationUpdateStrategy fSimulationUpdateStrategy;
    protected LogoComfort fEditor = null;
    protected InputSimulationBar fInputBlockBar = null;
    protected HideableToolBar fOutputBlockBar;
    protected Vector fInputBlocks = new Vector();
    protected Vector fOutputBlocks = null;
    protected Vector fToolBarIcons = null;
    protected Interpreter fInterpreter = null;
    protected boolean fActMode = false;
    protected transient MessageWindow fMessageWindow;
    protected transient PIControllerWindow fPIControllerWindow;
    private boolean fVisualisationEnabled;
    protected boolean initialRefresh = true;
    private WiringDiagram fWiringDiagram;

    public SimulationManager(LogoComfort editor, Interpreter interpreter) {
        this.fEditor = editor;
        this.fWiringDiagram = ((LogoDrawing)this.fEditor.drawing()).getWiringDiagram();
        this.fOutputBlockBar = new MinimizableToolbar();
        this.fOutputBlockBar.setName("OutputBlockBar");
        this.fOutputBlockBar.setTitle(Language.getString("toolbar.title.output", "Output blocks"));
        this.fOutputBlockBar.setHorizontalLayout(new ToolBarLayout(3, 0, 2));
        this.fOutputBlockBar.setFloatingFrameResizable(true);
        this.fInputBlockBar = new InputSimulationBar();
        this.fInterpreter = interpreter;
        this.fInterpreter.addInterpreterListener(new InterpreterHandler());
        this.fSimulationUpdateStrategy = new SimulationUpdateStrategy(editor.view());
        CSH.setHelpIDString((Component)this.fInputBlockBar, (String)"toolbar.simulation");
        CSH.setHelpIDString((Component)this.fOutputBlockBar, (String)"toolbar.simulation");
    }

    protected void drawSimulation() {
        LogoDrawing logoDrawing = (LogoDrawing)this.fEditor.view().drawing();
        if (logoDrawing.isSimulationPaintingFinished()) {
            logoDrawing.setSimulationPaintingFinished(false);
            logoDrawing.setChanged();
            logoDrawing.notifyObservers(null);
            if (this.initialRefresh) {
                this.initialRefresh = false;
                logoDrawing.checkDamage();
            }
        }
    }

    public LogoComfort getEditor() {
        return this.fEditor;
    }

    public MessageWindow getMessageWindow() {
        if (this.fInterpreter == null) {
            return null;
        }
        if (this.fMessageWindow == null) {
            this.fMessageWindow = MessageWindow.createMessageWindow(this.fEditor, this.getWiringDiagram().getMessageManager(), this.fInterpreter instanceof OnlineTestInterpreter);
            this.fMessageWindow.addWindowListener(new WindowAdapter(){

                public void windowClosed(WindowEvent e) {
                    if (SimulationManager.this.fEditor.tool() instanceof OnlineTestTool && SimulationManager.this.fInterpreter instanceof OnlineTestInterpreter) {
                        ((EnableMsgOnlineAction)((OnlineTestTool)SimulationManager.this.fEditor.tool()).getActionOwner().getActionFactory().getAction("DE.siemens.ad.pdraw.simulation.EnableMsgOnlineAction")).setSelected(false);
                        OnlineTestTool.setMsgOnlineTestEnabled(false);
                        ((OnlineTestInterpreter)SimulationManager.this.fInterpreter).setRequestedBlocks(((OnlineTestTool)SimulationManager.this.fEditor.tool()).getWatchedBlocks());
                    }
                    if (SimulationManager.this.fMessageWindow != null) {
                        SimulationManager.this.fMessageWindow.setCloseStatus(true);
                    }
                }
            });
        }
        return this.fMessageWindow;
    }

    public PIControllerWindow getPIControllerWindow() {
        if (this.fPIControllerWindow == null) {
            this.fPIControllerWindow = PIControllerWindow.createPIControllerWindow(this.fEditor);
            this.fPIControllerWindow.setOnlineTest(this.fInterpreter instanceof OnlineTestInterpreter);
        }
        return this.fPIControllerWindow;
    }

    public DataTableWindow getDataTableWindow() {
        if (!(this.fEditor.tool() instanceof RunningTool)) {
            return null;
        }
        return ((WatchDataTableAction)((RunningTool)((Object)this.fEditor.tool())).getActionOwner().getActionFactory().getAction("DE.siemens.ad.pdraw.simulation.WatchDataTableAction")).getDataTableWindow();
    }

    public JToolBar getOutputBlockBar() {
        return this.fOutputBlockBar;
    }

    public InputSimulationBar getInputBlockBar() {
        return this.fInputBlockBar;
    }

    public SimulationParameter getSimulationParameter(Block block) {
        return block.getSimulationParameter();
    }

    protected boolean isSimulationRunning() {
        return this.fActMode;
    }

    private void modeSwitched() {
        if (this.isSimulationRunning()) {
            this.createToolbars();
        }
    }

    public void resetOutputs() {
        for (int i = 0; i < this.fToolBarIcons.size(); ++i) {
            ((OutputDisplay)this.fToolBarIcons.elementAt(i)).reset();
        }
        this.fOutputBlockBar.repaint();
    }

    public void initOutputs() {
        for (int i = 0; i < this.fToolBarIcons.size(); ++i) {
            ((OutputDisplay)this.fToolBarIcons.elementAt(i)).init();
        }
        this.fOutputBlockBar.repaint();
    }

    public void resetInputs() {
        for (InputBlock inputBlock : this.fInputBlocks) {
            AbstractInputSimulationParameter inputSimulationParameter = (AbstractInputSimulationParameter)inputBlock.getSimulationParameter();
            if (inputSimulationParameter == null) continue;
            boolean intiaState = inputSimulationParameter.getSwitchMode() == 8;
            inputSimulationParameter.setBinaryValue(intiaState);
        }
    }

    public void parameterSet(Parameter parameter, String message) {
        if (parameter instanceof SimulationParameter && this.isSimulationRunning() && message.equals("switchModeChanged")) {
            this.createToolbars();
        }
    }

    protected void createToolbars() {
        Object[] blocks;
        this.fInputBlockBar.deregisterParameterSetListeners();
        OutputDisplay toolBarIcon = null;
        WiringDiagram wiringDiagram = ((LogoDrawing)this.fEditor.drawing()).getWiringDiagram();
        this.fInputBlocks = wiringDiagram.getInputBlocks();
        this.fOutputBlocks = wiringDiagram.getOutputBlocks();
        Collections.sort(this.fOutputBlocks, new BlockByNameComparator());
        int size = this.fInputBlocks.size();
        if (size > 0) {
            blocks = new InputBlock[size];
            SimulationParameter[] blockPars = new SimulationParameter[size];
            this.fInputBlocks.copyInto(blocks);
            Block.sortForBlockNumber((Block[])blocks);
            for (int k = 0; k < size; ++k) {
                SimulationParameter par;
                blockPars[k] = par = this.getSimulationParameter((Block)blocks[k]);
            }
            this.fInputBlockBar.init((InputBlock[])blocks, blockPars, this);
        } else {
            this.fInputBlockBar.emptyToolBar(this);
        }
        this.fToolBarIcons = new Vector();
        this.fOutputBlockBar.removeAll();
        size = this.fOutputBlocks.size();
        if (size > 0) {
            blocks = new OutputBlock[size];
            this.fOutputBlocks.copyInto(blocks);
            Block.sortForBlockNumber((Block[])blocks);
            for (int b = 0; b < size; ++b) {
                if (!wiringDiagram.getBlocks().contains(blocks[b])) continue;
                int signalType = ((OutputBlock)blocks[b]).getOutConnectorValueType();
                if (signalType == 0) {
                    toolBarIcon = new BinaryOutputDisplay((OutputBlock)blocks[b]);
                } else if (signalType == 1) {
                    toolBarIcon = new AnalogOutputDisplay((OutputBlock)blocks[b]);
                    this.getInterpreter().getStateMachine().addStateChangedListener(toolBarIcon);
                } else {
                    throw new IllegalArgumentException("No OutputDisplay-class available for output " + blocks[b]);
                }
                this.fToolBarIcons.addElement(toolBarIcon);
                this.fOutputBlockBar.add(toolBarIcon);
            }
        }
        if (this.fInputBlockBar.getParent() != null) {
            this.fInputBlockBar.getParent().validate();
        }
        if (this.fOutputBlockBar.getParent() != null) {
            this.fOutputBlockBar.getParent().validate();
        }
    }

    public void setSimulationMode(boolean newMode) {
        if (this.fActMode == newMode) {
            return;
        }
        if (newMode) {
            this.fSimulationUpdateStrategy.setNeedDrawAll(true);
        }
        this.fActMode = newMode;
        this.initialRefresh = true;
        if (newMode) {
            this.createToolbars();
            this.fInputBlocks = this.fWiringDiagram.getInputBlocks();
            this.fOutputBlocks = this.fWiringDiagram.getOutputBlocks();
            for (InputBlock inputBlock : this.fInputBlocks) {
                SimulationParameter par = this.getSimulationParameter(inputBlock);
                if (par != null) {
                    par.addParameterSetListener(this);
                }
                if (!(par instanceof AnalogInputSimulationParameter)) continue;
                ((AnalogInputSimulationParameter)par).addAsParameterSetListener();
            }
            ArrayList inputOutputBlocks = new ArrayList(this.fInputBlocks.size() + this.fOutputBlocks.size());
            inputOutputBlocks.addAll(this.fInputBlocks);
            inputOutputBlocks.addAll(this.fOutputBlocks);
            this.addAsBlockNameChangedListener(inputOutputBlocks);
            if (LogoProperties.instance().getBooleanProperty(SimulationOptionsPanel.SIMULATION_RESET, true)) {
                this.resetInputs();
            }
            this.fInterpreter.prepareInterpreter();
            this.fWiringDiagram.getMessageManager().verifyMessageLineParameterReferences();
            this.getMessageWindow().startSimulation();
            this.getPIControllerWindow().startSimulation();
            this.fInterpreter.start();
        } else {
            this.fInputBlockBar.deregisterParameterSetListeners();
            if (this.fMessageWindow != null) {
                this.fMessageWindow.endSimulation();
                this.fMessageWindow.dispose();
                this.fMessageWindow = null;
            }
            this.getPIControllerWindow().setVisible(false);
            this.getPIControllerWindow().endSimulation();
            if (this.fWiringDiagram.getHardware().supports("supportNetwork") && this.getDataTableWindow() != null) {
                this.getDataTableWindow().dispose();
            }
            Enumeration e = this.fInputBlocks.elements();
            Block b = null;
            while (e.hasMoreElements()) {
                b = (Block)e.nextElement();
                if (b.getSimulationParameter() != null) {
                    b.getSimulationParameter().removeParameterSetListener(this);
                }
                if (!(b.getSimulationParameter() instanceof AnalogInputSimulationParameter)) continue;
                ((AnalogInputSimulationParameter)b.getSimulationParameter()).removeAsParameterSetListener();
            }
            ArrayList inputOutputBlocks = new ArrayList(this.fInputBlocks.size() + this.fOutputBlocks.size());
            inputOutputBlocks.addAll(this.fInputBlocks);
            inputOutputBlocks.addAll(this.fOutputBlocks);
            this.removeAsBlockNameChangedListener(inputOutputBlocks);
            ((LogoDrawingView)this.fEditor.view()).repaint();
            for (int i = 0; i < this.fToolBarIcons.size(); ++i) {
                OutputDisplay outputDisplay = (OutputDisplay)this.fToolBarIcons.elementAt(i);
                if (!(outputDisplay instanceof AnalogOutputDisplay)) continue;
                this.getInterpreter().getStateMachine().removeStateChangedListener(outputDisplay);
            }
        }
    }

    private void removeAsBlockNameChangedListener(List inputOutputBlocks) {
        for (Block block : inputOutputBlocks) {
            block.removeBlockNameChangedListener(this);
        }
    }

    private void addAsBlockNameChangedListener(List inputOutputBlocks) {
        for (Block block : inputOutputBlocks) {
            block.addBlockNameChangedListener(this);
        }
    }

    public void blockNameChanged(Block newBlock) {
        this.modeSwitched();
    }

    public Interpreter getInterpreter() {
        return this.fInterpreter;
    }

    public void setVisualisationEnabled(boolean visualisationEnabled) {
        boolean doubleBuffered;
        if (visualisationEnabled == this.fVisualisationEnabled) {
            return;
        }
        this.fVisualisationEnabled = visualisationEnabled;
        Painter updateStrategy = null;
        if (visualisationEnabled) {
            updateStrategy = this.fSimulationUpdateStrategy;
            updateStrategy.setParameterValuesDisabled(this.fInterpreter instanceof OnlineTestInterpreter);
            doubleBuffered = false;
        } else {
            updateStrategy = new BufferedUpdateStrategy();
            doubleBuffered = true;
        }
        Iterator i = this.fEditor.getViews().iterator();
        LogoDrawingView drawingView = null;
        while (i.hasNext()) {
            drawingView = (LogoDrawingView)i.next();
            drawingView.setDisplayUpdate(updateStrategy);
            drawingView.setDoubleBuffered(doubleBuffered);
        }
        this.fEditor.getApplicationSurface().repaint();
    }

    public boolean isVisualisationEnabled() {
        return this.fVisualisationEnabled;
    }

    public void setEditor(LogoComfort editor) {
        this.fEditor = editor;
        this.fSimulationUpdateStrategy.initialize(editor.view());
        this.fPIControllerWindow = null;
    }

    public WiringDiagram getWiringDiagram() {
        return this.fWiringDiagram;
    }

    public void setWiringDiagram(WiringDiagram fWiringDiagram) {
        this.fWiringDiagram = fWiringDiagram;
    }

    protected class InterpreterHandler
    implements InterpreterListener {
        protected InterpreterHandler() {
        }

        public void interpreterCycleFinished(boolean somethingChanged) {
            if (!somethingChanged) {
                return;
            }
            for (int i = 0; i < SimulationManager.this.fToolBarIcons.size(); ++i) {
                ((OutputDisplay)SimulationManager.this.fToolBarIcons.elementAt(i)).setState();
            }
            SimulationManager.this.fOutputBlockBar.repaint();
            SimulationManager.this.drawSimulation();
            SimulationManager.this.getMessageWindow().interpreterCycleFinished();
            if (SimulationManager.this.getDataTableWindow() != null) {
                SimulationManager.this.getDataTableWindow().interpreterCycleFinished();
            }
        }
    }
}

